/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockBeacon;
import minecrafttransportsimulator.blocks.instances.BlockCharger;
import minecrafttransportsimulator.blocks.instances.BlockChest;
import minecrafttransportsimulator.blocks.instances.BlockDecor;
import minecrafttransportsimulator.blocks.instances.BlockFluidLoader;
import minecrafttransportsimulator.blocks.instances.BlockFuelPump;
import minecrafttransportsimulator.blocks.instances.BlockItemLoader;
import minecrafttransportsimulator.blocks.instances.BlockRadio;
import minecrafttransportsimulator.blocks.instances.BlockSignalController;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;

public class ItemDecor
extends AItemSubTyped<JSONDecor>
implements IItemBlock {
    public ItemDecor(JSONDecor definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public Class<? extends ABlockBase> getBlockClass() {
        switch (((JSONDecor)this.definition).decor.type) {
            case CHEST: {
                return BlockChest.class;
            }
            case BEACON: {
                return BlockBeacon.class;
            }
            case SIGNAL_CONTROLLER: {
                return BlockSignalController.class;
            }
            case FUEL_PUMP: {
                return BlockFuelPump.class;
            }
            case CHARGER: {
                return BlockCharger.class;
            }
            case ITEM_LOADER: 
            case ITEM_UNLOADER: {
                return BlockItemLoader.class;
            }
            case FLUID_LOADER: 
            case FLUID_UNLOADER: {
                return BlockFluidLoader.class;
            }
            case RADIO: {
                return BlockRadio.class;
            }
            case SEAT: 
            case GENERIC: {
                return BlockDecor.class;
            }
        }
        return null;
    }

    @Override
    public ABlockBase createBlock() {
        switch (((JSONDecor)this.definition).decor.type) {
            case CHEST: {
                return new BlockChest();
            }
            case BEACON: {
                return new BlockBeacon();
            }
            case SIGNAL_CONTROLLER: {
                return new BlockSignalController();
            }
            case FUEL_PUMP: {
                return new BlockFuelPump();
            }
            case CHARGER: {
                return new BlockCharger();
            }
            case ITEM_LOADER: 
            case ITEM_UNLOADER: {
                return new BlockItemLoader();
            }
            case FLUID_LOADER: 
            case FLUID_UNLOADER: {
                return new BlockFluidLoader();
            }
            case RADIO: {
                return new BlockRadio();
            }
            case SEAT: 
            case GENERIC: {
                return new BlockDecor();
            }
        }
        return null;
    }
}

